# 스레드풀 & 웹서버

지난 시간 우리는 프로세스와 함께 스레드의 개념에 대해 알아보았다.

그렇다면 단순히 thread만 사용해서 동시에 여러 작업을 실행시킬 수 있는 프로그램을 만들 수 있을까?

간단하게 말하자면 매우 비효율적!

요청이 올 때마다 새로운 thread를 생성하고, 처리가 끝나면 thread를 제거하는 과정의 문제점

1. Thread 생성 비용이 크기 때문에 요청에 대한 **응답시간이 늘어남**.
    - Java는 One-to-One Threading-Model로 Thread를 생성함.
    - One-to-One Threading-Model로 생성한다는 것은 User Thread(Process의 스레드) 생성시 OS Thread(OS 레벨의 스레드)와 연결한다는 것을 의미.
    - 즉, 새로운 Thread를 생성할 때마다 OS Kernel의 작업이 필요
        
        → 즉, 작업 요청이 들어올 때마다 Thread를 생성하면 최종적인 요청 처리 시간이 증가!!!!
        
2. Thread가 많을 경우 **메모리 문제** 혹은 **CPU 오버헤드가 증가**함.
    - Process의 처리 속도보다 빠르게 요청이 쏟아져 들어올 경우
    - 새로운 Thread가 무제한적으로 계속 생성된다
    - Thread가 많아질수록 메모리를 차지하고, Context-Switching이 더 자주 발생한다.
        
        → 즉, 무제한적으로 thread가 생성될 경우 메모리 문제 발생 & CPU 오버헤드 증가
        
    

위와 같은 문제를 해결하기 위한 것이 **Thread Pool**!!

Thread Pool이란? Thread를 허용된 개수 안에서 사용하도록 제한하는 시스템!

Thread Pool은 사용할 Thread들과 작업 큐로 구성되어 있음.

![Untitled](%E1%84%89%E1%85%B3%E1%84%85%E1%85%A6%E1%84%83%E1%85%B3%E1%84%91%E1%85%AE%E1%86%AF%20&%20%E1%84%8B%E1%85%B0%E1%86%B8%E1%84%89%E1%85%A5%E1%84%87%E1%85%A5%2064ccef000fd84480a56d93c9e8d87a64/Untitled.png)

스레드 풀에 작업 요청이 들어오면 작업 큐(Task Queue)에 작업들이 쌓이게 되고 스레드풀의 스레드가 작업 큐에 있는 작업을 빼서 처리하게 됨. 스레드 풀을 사용할 경우 정해진 양만큼의 스레드를 사용할 뿐 아니라 작업을 끝낸 스레드를 재사용할 수 있음!

위의 과정을 통해 확인할 수 있는 Thread Pool의 장점!

1. 미리 만들어 놓은 Thread를 재사용할 수 있기 때문에 새로운 Thread를 생성하는 비용을 줄일 수 있다.
    
    → 위에서 말한 작업 요청이 들어올 때마다 Thread를 생성할 경우 최종적인 요청 처리 시간이 증가한다는 문제를 해결할 수 있음
    
2. 사용할 Thread 개수를 제한하기 때문에 무제한적으로 스레드가 생성되는 걸 방지할 수 있다.
    
    → 메모리 문제 발생 가능성과 CPU 오버헤드 증가를 줄일 수 있음
    

Java에서는 ThreadPoolExecutor을 사용하여 쓰레드 풀을 구현하고 있음.

- maxmimumPoolSize: 스레드 풀에서 사용할 수 있는 최대 스레드 개수. 그러나 늘 최대의 thread만큼 생성해 놓는 것은 아님. 요청이 적을 땐 많은 스레드를 생성하여 유지하는 것이 비효율적이기 때문! 따라서 이 개수를 최적화하는 기능들이 ThreadPoolExecutor에는 들어가 있음.
- keepAliveTime: 만일 thread 개수가 maximumPoolSize의 수만큼 최대였는데 keepAliveTime의 시간동안 요청이 없을 경우, 스레드는 없어짐.
- corePoolSize: 그러나 최적화 과정에서 스레드가 무한히 사라지는 것이 아니라 corePoolSize은 남긴 상태로 없어짐.
    
    즉, ThreadPoolExecutor을 통해 thread는 최대 maximumPoolSize만큼 가질 수 있고, 최소 corePoolSize만큼의 스레드를 유지하고 있음.
    
    위와 같은 특징들을 통해 알 수 있듯 여러 개의 작업을 동시에 처리하면서도 안정적으로 처리하고 싶을 때 Thread Pool은 효과적!
    
    이러한 Thread Pool을 잘 활용할 수 있는 것이 Web Server!
    
    웹서버는 특성상 동시적 요청을 동시적으로 처리해야 함. 따라서 많은 웹 서버가 스레드풀을 사용하여 동시 요청을 처리함.
    
    대표적으로 Tomcat의 경우 SpringBoot의 내장 Servlet Conatiner 중 하나로 Java 기반의 WAS임.
    
    ![Untitled](%E1%84%89%E1%85%B3%E1%84%85%E1%85%A6%E1%84%83%E1%85%B3%E1%84%91%E1%85%AE%E1%86%AF%20&%20%E1%84%8B%E1%85%B0%E1%86%B8%E1%84%89%E1%85%A5%E1%84%87%E1%85%A5%2064ccef000fd84480a56d93c9e8d87a64/Untitled%201.png)
    
    Java의 Thread Pool 클래스와 매우 유사한 자체 스레드 풀 구현체를 가지고 있음. 다른 것은 자바의 스레드풀 구현체와 유사하지만 두 가지 차이점이 있음.
    
    1. Max-Connections : 톰캣이 최대로 동시에 처리할 수 있는 connection의 수.
        
         톰캣에 웹 요청이 들어오면 Tomcat의 Connector Component가 **Connection**을 생성하며 요청된 작업을 Thread Pool의 Thread에 연결하게 됨. 이 때 동시에 연결할 수 있는 Connection의 최대 수가 바로 **max-connection**
        
    2. Accept-Count : Max-connections 이상의 요청이 들어왔을 때의 대기열 queue의 사이즈를 Accept-count라고 함.
        
        Max-Connections와 Accept-Count 이상의 요청이 들어오면 추가적으로 들어오는 요청은 거절될 수 있음.
        
        어떻게 Thread Pool 설정을 하면 Server Application을 효과적으로 구현할 수 있을까?
        
        1. server.tomcat.threads.max : 
            
            thread-max property. 스레드풀에서 사용할 수 있는 **최대 스레드 개수**를 의미하며 기본값은 200
            
        2. server.tomcat.threads.min-spare : 
            
            thread pool에서 **최소**한으로 유지할 **thread 개수**를 의미하며 기본값은 10
            
        3. server.tomcat.max-connections
            
            동시에 처리할 수 있는 **최대 Connection 의 개수**, 기본값은 8192
            
            : 사실상 서버의 실질적인 동시 요청 처리 개수라고 생각할 수 있다.
            
        4. server.tomcat.accept-count
            
            max-connections 이상의 요청이 들어왔을 때 사용하는 요청 **대기열 Queue 사이즈**를 의미하며 기본값은 100
            
    
    서버 어플리케이션의 품질은 동시에 처리할 수 있는 요청 개수와 관련있다.
    
    잘못된 설정으로 생겨날 수 있는 시나리오는 2가지
    
    1. 요청수에 비해 너무 많게 설정 -> 놀고 있는 스레드가 많아져 메모리,cpu 자원 비효율 증대
    2. 너무 적게 설정 -> 동시 처리 요청수가 줄어든다. 평균 응답 시간 증가, TPS 감소
    
    우리가 Thread Pool을 잘 설정해야 하는 이유
    
    - Thread Pool은 응답시간과 TPS에 영향을 주는 하나의 요소
    - 잘 조정된 Thread Pool은 시스템의 성능을 끌어내고 안정적인 어플리케이션 운용을 가능하게 함
    - 부적절하게 설정된 Thread Pool은 병목 현상, CPU 오버헤드, 메모리 문제를 유발할 수 있기 때문.
